% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hs_class.R
\name{hs_class}
\alias{hs_class}
\title{Horseshoe regression Gibbs-sampler for classification}
\usage{
hs_class(X, y, niter, hsplus = F, prior, thin = 1, restricted = 0.001)
}
\arguments{
\item{X}{A matrix containing the predictor variables to be used.}

\item{y}{The vector of numeric responses.}

\item{niter}{Number of posterior samples.}

\item{hsplus}{If "hsplus=T" the horseshoe+ extension will be used.}

\item{prior}{Prior for the individual predictors. If all 1 a standard horseshoe model is fit.}

\item{thin}{If > 1 thinning is performed to reduce autocorrelation.}

\item{restricted}{Threshold for restricted Gibbs sampling. In each iteration only coefficients with scale > restricted are updated. Set restricted = 0 for unrestricted Gibbs sampling.}
}
\value{
A list containing the posterior samples of the following parameters:
\item{beta}{Matrix containing the posterior samples for the regression coefficients.}
 \item{sigma}{Vector contraining the Posterior samples of the error variance.}
 \item{tau}{Vector contraining the Posterior samples of the overall shrinkage.}
\item{lambda}{Matrix containing the posterior samples for the individual shrinkage parameter.}
}
\description{
Generates posterior samples using the horseshoe prior using the polya gamma data augmentation approach for logistic regression.
}
