% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_dep.R
\name{partial_dep}
\alias{partial_dep}
\alias{partial_dep.default}
\alias{partial_dep.ranger}
\alias{partial_dep.Learner}
\alias{partial_dep.explainer}
\title{Partial Dependence Plot}
\usage{
partial_dep(object, ...)

\method{partial_dep}{default}(
  object,
  v,
  X,
  pred_fun = stats::predict,
  BY = NULL,
  by_size = 4L,
  grid = NULL,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile"),
  n_max = 1000L,
  w = NULL,
  ...
)

\method{partial_dep}{ranger}(
  object,
  v,
  X,
  pred_fun = function(m, X, ...) stats::predict(m, X, ...)$predictions,
  BY = NULL,
  by_size = 4L,
  grid = NULL,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile"),
  n_max = 1000L,
  w = NULL,
  ...
)

\method{partial_dep}{Learner}(
  object,
  v,
  X,
  pred_fun = NULL,
  BY = NULL,
  by_size = 4L,
  grid = NULL,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile"),
  n_max = 1000L,
  w = NULL,
  ...
)

\method{partial_dep}{explainer}(
  object,
  v,
  X = object[["data"]],
  pred_fun = object[["predict_function"]],
  BY = NULL,
  by_size = 4L,
  grid = NULL,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile"),
  n_max = 1000L,
  w = object[["weights"]],
  ...
)
}
\arguments{
\item{object}{Fitted model object.}

\item{...}{Additional arguments passed to \code{pred_fun(object, X, ...)},
for instance \code{type = "response"} in a \code{\link[=glm]{glm()}} model.}

\item{v}{Vector of feature names, by default \code{colnames(X)}.}

\item{X}{A data.frame or matrix serving as background dataset.}

\item{pred_fun}{Prediction function of the form \verb{function(object, X, ...)},
providing \eqn{K \ge 1} predictions per row. Its first argument represents the
model \code{object}, its second argument a data structure like \code{X}. Additional arguments
(such as \code{type = "response"} in a GLM, or \code{reshape = TRUE} in a multiclass XGBoost
model) can be passed via \code{...}. The default, \code{\link[stats:predict]{stats::predict()}}, will work in
most cases.}

\item{BY}{Optional grouping vector or a column name. The partial dependence
function is calculated per \code{BY} group. Each \code{BY} group
uses the same evaluation grid to improve assessment of (non-)additivity.
Numeric \code{BY} variables with more than \code{by_size} disjoint values will be
binned into \code{by_size} quantile groups of similar size. Subsampling of \code{X} is done
within group to improve robustness.}

\item{by_size}{Numeric \code{BY} variables with more than \code{by_size} unique values will
be binned into quantile groups. Only relevant if \code{BY} is not \code{NULL}.}

\item{grid}{Evaluation grid. A vector (if \code{length(v) == 1L}), or a matrix/data.frame
otherwise. If \code{NULL}, calculated via \code{\link[=multivariate_grid]{multivariate_grid()}}.}

\item{grid_size}{Controls the approximate grid size. If \code{x} has p columns, then each
(non-discrete) column will be reduced to about the p-th root of \code{grid_size} values.}

\item{trim}{The default \code{c(0.01, 0.99)} means that values outside the
1\% and 99\% quantiles of non-discrete numeric columns are removed before calculation
of grid values. Set to \code{0:1} for no trimming.}

\item{strategy}{How to find grid values of non-discrete numeric columns?
Either "uniform" or "quantile", see description of \code{\link[=univariate_grid]{univariate_grid()}}.}

\item{n_max}{If \code{X} has more than \code{n_max} rows, a random sample of \code{n_max} rows is
selected from \code{X}. In this case, set a random seed for reproducibility.}

\item{w}{Optional vector of case weights for each row of \code{X}.}
}
\value{
An object of class "partial_dep" containing these elements:
\itemize{
\item \code{data}: data.frame containing the partial dependencies.
\item \code{v}: Same as input \code{v}.
\item \code{K}: Number of columns of prediction matrix.
\item \code{pred_names}: Column names of prediction matrix.
\item \code{by_name}: Column name of grouping variable (or \code{NULL}).
}
}
\description{
Estimates the partial dependence function of feature(s) \code{v} over a
grid of values. Both multivariate and multivariable situations are supported.
The resulting object can be plotted via \code{plot()}.
}
\section{Methods (by class)}{
\itemize{
\item \code{partial_dep(default)}: Default method.

\item \code{partial_dep(ranger)}: Method for "ranger" models.

\item \code{partial_dep(Learner)}: Method for "mlr3" models.

\item \code{partial_dep(explainer)}: Method for DALEX "explainer".

}}
\section{Partial Dependence Functions}{


Let \eqn{F: R^p \to R} denote the prediction function that maps the
\eqn{p}-dimensional feature vector \eqn{\mathbf{x} = (x_1, \dots, x_p)}
to its prediction. Furthermore, let
\deqn{
  F_s(\mathbf{x}_s) = E_{\mathbf{x}_{\setminus s}}(F(\mathbf{x}_s, \mathbf{x}_{\setminus s}))
}
be the partial dependence function of \eqn{F} on the feature subset
\eqn{\mathbf{x}_s}, where \eqn{s \subseteq \{1, \dots, p\}}, as introduced in
Friedman (2001). Here, the expectation runs over the joint marginal distribution
of features \eqn{\mathbf{x}_{\setminus s}} not in \eqn{\mathbf{x}_s}.

Given data, \eqn{F_s(\mathbf{x}_s)} can be estimated by the empirical partial
dependence function

\deqn{
  \hat F_s(\mathbf{x}_s) = \frac{1}{n} \sum_{i = 1}^n F(\mathbf{x}_s, \mathbf{x}_{i\setminus s}),
}
where \eqn{\mathbf{x}_{i\setminus s}} \eqn{i = 1, \dots, n}, are the observed values
of \eqn{\mathbf{x}_{\setminus s}}.

A partial dependence plot (PDP) plots the values of \eqn{\hat F_s(\mathbf{x}_s)}
over a grid of evaluation points \eqn{\mathbf{x}_s}.
}

\examples{
# MODEL 1: Linear regression
fit <- lm(Sepal.Length ~ . + Species * Petal.Length, data = iris)
(pd <- partial_dep(fit, v = "Species", X = iris))
plot(pd)

# Stratified by BY variable (numerics are automatically binned)
pd <- partial_dep(fit, v = "Species", X = iris, BY = "Petal.Length")
plot(pd)

# Multivariable input
v <- c("Species", "Petal.Width")
pd <- partial_dep(fit, v = v, X = iris, grid_size = 100L)
plot(pd, rotate_x = TRUE)

# With grouping
pd <- partial_dep(fit, v = v, X = iris, grid_size = 100L, BY = "Petal.Length")
plot(pd, rotate_x = TRUE)

# MODEL 2: Multi-response linear regression
fit <- lm(as.matrix(iris[1:2]) ~ Petal.Length + Petal.Width * Species, data = iris)
pd <- partial_dep(fit, v = "Petal.Width", X = iris, BY = iris$Species)
plot(pd, show_points = FALSE)
plot(partial_dep(fit, v = c("Species", "Petal.Width"), X = iris), rotate_x = TRUE)

# Multivariate, multivariable, and BY (no plot available)
pd <- partial_dep(fit, v = c("Petal.Width", "Petal.Length"), X = iris, BY = "Species")
pd

# MODEL 3: Gamma GLM -> pass options to predict() via ...
fit <- glm(Sepal.Length ~ ., data = iris, family = Gamma(link = log))
plot(partial_dep(fit, v = "Petal.Length", X = iris))
plot(partial_dep(fit, v = "Petal.Length", X = iris, type = "response"))
}
\references{
Friedman, Jerome H. \emph{"Greedy Function Approximation: A Gradient Boosting Machine."}
Annals of Statistics 29, no. 5 (2001): 1189-1232.
}
