% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmlview.R
\name{xml_view}
\alias{xml_view}
\alias{html_view}
\title{HTML/XML pretty printer and viewer}
\usage{
xml_view(doc, style = "default", scroll = FALSE, add_filter = FALSE,
  apply_xpath = NULL, elementId = NULL, width = "100\%", height = NULL)

html_view(doc, style = "default", scroll = FALSE, add_filter = FALSE,
  apply_xpath = NULL, elementId = NULL, width = "100\%", height = NULL)
}
\arguments{
\item{doc}{\code{xml2} document/node/nodeset, an \code{HTMLInternalDocument}/
\code{XMLInternalDocument} or atomic character vector of HTML/XML content}

\item{style}{CSS stylesheet to use (see \code{higlight_styles()})}

\item{scroll}{should the \code{<div>} holding the HTML/XML content scroll
(\code{TRUE}) or take up the full viewer/browser window (\code{FALSE}).
Default is \code{FALSE} (take up the full viewer/browser window). If
this is set to \code{TRUE}, \code{height} should be set to a value
other than \code{NULL}.}

\item{add_filter}{show an XPath input box to enable live filtering?
(default: \code{FALSE})}

\item{apply_xpath}{Add and apply an XPath query string to the view. If
\code{add_filter} is \code{TRUE} then this query string will
appear in the filter box and be applied to the passed in document.}

\item{elementId}{element id}

\item{width}{widget width (best to keep it at 100\%)}

\item{height}{widget height (kinda only useful for knitting since this is
meant to be an interactive tool).}
}
\description{
This uses the \code{vkbeautify} and \code{highlight.js} javascript modules to format and
"pretty print" HTML/XML documents, nodes, node sets and plain character
HTML/XML in an \code{htmlwidget} pane.
}
\note{
Large HTML or XML content may take some time to render properly. It is suggested
      that this function be used on as minimal of a subset of HTML/XML as possible
      or used in a browser context vs an IDE viewer context.
}
\examples{
if (interactive()) {
library(xml2)

# plain text
txt <- paste0("<note><to>Tove</to><from>Jani</from><heading>Reminder</heading>",
              "<body>Don't forget me this weekend!</body></note>")
xml_view(txt)

# xml object
doc <- read_xml(txt)
xml_view(doc, style="obsidian")

# different style
xml_view(xml_find_all(doc, ".//to"), style="github-gist")

# some more complex daata
xml_view(read_xml(system.file("extdata/dwml.xml", package="htmltidy")))
xml_view(read_xml(system.file("extdata/getHistory.xml", package="htmltidy")),
         "androidstudio")
xml_view(read_xml(system.file("extdata/input.xml", package="htmltidy")),
         "sunburst")

# filter + apply an initial XPath query string
xml_view(read_xml(system.file("extdata/dwml.xml", package="xmlview")),
         add_filter=TRUE, apply_xpath=".//temperature")

doc <- read_xml("http://www.npr.org/rss/rss.php?id=1001")

str(doc)

xml_view(doc, add_filter=TRUE)
xml2::xml_find_all(doc, './/dc:creator', ns=xml2::xml_ns(doc))

xml_text(xml2::xml_find_all(doc, './/link[contains(., "soccer")]', ns=xml2::xml_ns(doc)))
}
}
\references{
\href{https://highlightjs.org/}{highlight.js},
            \href{http://www.eslinstructor.net/vkbeautify/}{vkbeautify}
}
