% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_discalib.R
\name{p_discalib}
\alias{p_discalib}
\title{Plot calibration curves water levels vs discharges}
\usage{
p_discalib(
  caldis,
  plotcalib = TRUE,
  plotdism = TRUE,
  title = "Title",
  savefig = FALSE,
  width = 8,
  height = 6,
  fout = "plot.png",
  limx = FALSE,
  limy = FALSE,
  xinf = NA,
  xsup = NA,
  yinf = NA,
  ysup = NA
)
}
\arguments{
\item{caldis}{List of calibration  and discharge measurments to proceed}

\item{plotcalib}{Plot calibrations TRUE (defautl) / FALSE}

\item{plotdism}{Plot discharge measurements TRUE (defautl) / FALSE}

\item{title}{Plot title (default: Title)}

\item{savefig}{Save plot in a png file TRUE (default) / FALSE}

\item{width}{Plot width (x 100 pixels) (default = 8)}

\item{height}{Plot height (x 100 pixels) (default = 6)}

\item{fout}{Plot file name (default = "plot.png")}

\item{limx}{Limit x axis TRUE / FALSE (default)}

\item{limy}{Limit y axis TRUE / FALSE (default)}

\item{xinf}{Low value for x (default = NA)}

\item{xsup}{High value for x (default = NA)}

\item{yinf}{Low value for y (default = NA)}

\item{ysup}{High value for y (default = NA)}
}
\description{
Experimental function, which is for instance limited to only two calibration curves on the same plot.

The function plot the discharges measurements and the corresponding
calibration curves starting from a 'caldis' list generated by the \code{\link{d_exp_discalib}}
function.

Only the "active" discharge measurements are plotted. The parameter plotdism displays
them or not.

One can zoom on a subpart of the plot using the limit values on the x and y axis.

The savefig (default = FALSE by default) parameter allows to save the result i a  png, jpg or pdf
file, according to the extention of fout.
}
\author{
P. Chevallier - Sep 2017 - Nov 2020
}
