% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hep_bioavailability.R
\name{calc_hep_bioavailability}
\alias{calc_hep_bioavailability}
\title{Calculate first pass heaptic metabolism}
\usage{
calc_hep_bioavailability(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  restrictive.clearance = TRUE,
  flow.34 = TRUE,
  suppress.messages = FALSE,
  species = "Human"
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
 -- if parameters is not specified then the chemical must be identified by 
either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from the appropriate parameterization function
for the model indicated by argument model}

\item{restrictive.clearance}{Protein binding not taken into account (set to 1) in 
liver clearance if FALSE.}

\item{flow.34}{A logical constraint}

\item{suppress.messages}{Whether or not to suppress the output message.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}
}
\value{
A data.table whose columns are the parameters of the HTTK model
 specified in \code{model}.
}
\description{
For models that don't described first pass blood flow from the gut, need to
cacluate a hepatic bioavailability, that is, the fraction of chemical 
systemically available after metabolism during the first pass through the 
liver (Rowland, 1973 Equation 29, where k21 is blood flow through the liver
and k23 is clearance from the liver in Figure 1 in that paper).
}
\references{
\insertRef{rowland1973clearance}{httk}
}
\author{
John Wambaugh
}
\keyword{physiology}
