% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-device.R
\name{oauth_flow_device}
\alias{oauth_flow_device}
\title{OAuth flow: device}
\usage{
oauth_flow_device(
  client,
  auth_url,
  scope = NULL,
  auth_params = list(),
  token_params = list()
)
}
\arguments{
\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{auth_url}{Authorization url; you'll need to discover this by reading
the documentation.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{auth_params}{List containing additional parameters passed to \code{oauth_flow_auth_code_url()}}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
An \link{oauth_token}.
}
\description{
These functions implement the OAuth device flow, as defined
by \href{https://datatracker.ietf.org/doc/html/rfc8628}{rfc8628}. It's designed
for devices that don't have access to a web browser (if you've ever
authenticated an app on your TV, this is probably the flow you've used),
but it also works well from within R.
}
\seealso{
Other OAuth flows: 
\code{\link{oauth_flow_auth_code}()},
\code{\link{oauth_flow_bearer_jwt}()},
\code{\link{oauth_flow_client_credentials}()},
\code{\link{oauth_flow_password}()},
\code{\link{oauth_flow_refresh}()}
}
\concept{OAuth flows}
\keyword{internal}
