% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-throttle.R
\name{req_throttle}
\alias{req_throttle}
\title{Throttle a request by automatically adding a delay}
\usage{
req_throttle(req, rate, realm = NULL)
}
\arguments{
\item{req}{A \link{request}.}

\item{rate}{Maximum rate, i.e. maximum number of requests per second.
Usually easiest expressed as a fraction,
\code{number_of_requests / number_of_seconds}, e.g. 15 requests per minute
is \code{15 / 60}.}

\item{realm}{An unique identifier that for throttle pool. If not supplied,
defaults to the hostname of the request.}
}
\value{
A modified HTTP \link{request}.
}
\description{
Use \code{req_throttle()} to ensure that repeated calls to \code{\link[=req_perform]{req_perform()}} never
exceed a specified rate.
}
\examples{
# Ensure server will never recieve more than 10 requests a minute
request("https://example.com") \%>\%
  req_throttle(rate = 10 / 60)
}
\seealso{
\code{\link[=req_retry]{req_retry()}} for another way of handling rate-limited APIs.
}
