% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-template.R
\name{req_template}
\alias{req_template}
\title{Set request method/path from a template}
\usage{
req_template(req, template, ..., .env = parent.frame())
}
\arguments{
\item{req}{A \link{request}.}

\item{template}{A template string which consists of a optional HTTP method
and a path containing variables labelled like either \verb{:foo} or \code{{foo}}.}

\item{...}{Template variables.}

\item{.env}{Environment in which to look for template variables not found
in \code{...}. Expert use only.}
}
\value{
A modified HTTP \link{request}.
}
\description{
Many APIs document their methods with a lightweight template mechanism
that looks like \code{GET /user/{user}} or \verb{POST /organisation/:org}. This
function makes it easy to copy and paste such snippets and retrieve template
variables either from function arguments or the current environment.

\code{req_template()} will append to the existing path so that you can set a
base url in the initial \code{\link[=request]{request()}}. This means that you'll generally want
to avoid multiple \code{req_template()} calls on the same request.
}
\examples{
httpbin <- request("http://httpbin.org")

# You can supply template parameters in `...`
httpbin \%>\% req_template("GET /bytes/{n}", n = 100)

# or you retrieve from the current environment
n <- 200
httpbin \%>\% req_template("GET /bytes/{n}")

# Existing path is preserved:
httpbin_cookies <- request("http://httpbin.org/cookies")
name <- "id"
value <- "a3fWa"
httpbin_cookies \%>\% req_template("GET /set/{name}/{value}")
}
