% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{set.chr.to.char}
\alias{set.chr.to.char}
\title{Change the chromosome labels in a RangedData or GRanges object to string codes}
\usage{
set.chr.to.char(ranged, do.x.y = T, keep = T)
}
\arguments{
\item{ranged}{A GRanges or RangedData object}

\item{do.x.y}{logical, if TRUE then the usual numbers allocated to chromosomes, X,Y,XY, MT will
be allocated as 23,24,25,26 respectively. If false, these will just have 'chr' appended as a
prefix}

\item{keep}{logical, whether to keep additional metadata columns in the new object}
}
\value{
returns the 'ranged' object, but wherever a chromosome number was previously, a character
label, e.g, 'chr1', or 'X', will returned to replace the number, e.g, 1 or 23 respectively. 
If table.out is TRUE will return a list where the first element is the resulting object, and the second 
element is a table showing which numbers were converted to what label This table
can then be used for future conversions via the parameter 'table.in' to ensure consistency of
coding.
}
\description{
Change the chromosome labels in a RangedData or GRanges object to string codes
}
\examples{
x <- rranges()
x
x <- set.chr.to.numeric(x) # make entirely numeric
x <- rranges(chr.range=20:26)
# next two will give warning about X, Y, etc
set.chr.to.char(x) # 23 = chrX, etc
set.chr.to.char(x,do.x.y=FALSE) # 23=chr23, etc
}
\seealso{
\code{\link{set.chr.to.numeric}}
}

