% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping-functions.R
\name{by_quantiles}
\alias{by_quantiles}
\alias{by_equal_groups}
\title{Map numeric quantiles to cell properties}
\usage{
by_quantiles(quantiles, values, right = FALSE, extend = TRUE,
  ignore_na = TRUE, colwise = FALSE)

by_equal_groups(n, values, ignore_na = TRUE, colwise = FALSE)
}
\arguments{
\item{quantiles}{Vector of quantiles.}

\item{values}{Vector of values. \code{length(values)} should be one greater than \code{length(quantiles)},
or one less if \code{extend = FALSE}.}

\item{right}{If \code{TRUE}, intervals are closed on the right, i.e. if values are exactly equal to a
\code{break}, they go in the lower group. Otherwise, intervals are closed on the left, so equal
values go in the higher group. \code{FALSE} by default.}

\item{extend}{Extend \code{breaks} to \code{c(-Inf, breaks, Inf)}, i.e. include numbers below and above the
outermost breaks. \code{TRUE} by default.}

\item{ignore_na}{If \code{TRUE}, \code{NA} values in the result will be left unchanged. Otherwise, \code{NA}
normally resets to the default.}

\item{colwise}{Logical. Calculate breaks separately within each column?}

\item{n}{Number of equal-sized groups. \code{length(values)} should equal \code{n}.}
}
\value{
A function for use in \code{map_***} functions.
}
\description{
These functions split cell values by quantiles. Non-numeric cells are ignored.
}
\details{
\code{by_equal_groups(n, values)} splits the data into \code{n} equal-sized groups (i.e. it is a shortcut
for \code{by_quantiles(seq(1/n, 1 - 1/n, 1/n), values)}).
}
\examples{
ht <- hux(rnorm(5), rnorm(5))

map_background_color(ht,
      by_quantiles(
        c(0.2, 0.8),
        c("red", "yellow", "green")
      ))

map_background_color(ht,
      by_quantiles(
        c(0.2, 0.8),
        c("red", "yellow", "green"),
        colwise = TRUE
      ))

map_background_color(ht,
      by_equal_groups(
        3,
        c("red", "yellow", "green")
      ))
}
\seealso{
\link{mapping-functions}

Other mapping functions: \code{\link{by_cases}},
  \code{\link{by_colorspace}}, \code{\link{by_function}},
  \code{\link{by_ranges}}, \code{\link{by_regex}},
  \code{\link{by_rows}}, \code{\link{by_values}}
}
\concept{mapping functions}
