% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge_repeated_rows}
\alias{merge_repeated_rows}
\title{Merge repeated rows into multirow cells}
\usage{
merge_repeated_rows(ht, row, col)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}
}
\value{
The \code{ht} object.
}
\description{
\code{merge_repeated_rows()} looks within each column for
contiguous groups of identical cells. These are merged
by setting \code{\link[=rowspan]{rowspan()}}. Doing this helps remove redundant
information from the table.
}
\details{
If \code{row} contains gaps, results may be unexpected (and a warning is given).
}
\section{Cell content}{

In merged cell ranges, only the top left cell's content is displayed.
In addition, when you merge cells (either by setting \code{\link[=colspan]{colspan()}} or
\code{\link[=rowspan]{rowspan()}}, or using \code{\link[=merge_cells]{merge_cells()}} and friends) the content of the top
left cell is copied to other cells. This prevents unexpected changes to
content if you reorder or subset rows and columns.
}

\examples{
ht <- as_hux(jams[c(1, 2, 2, 3, 3, 4), ])
ht <- add_columns(ht, c("Sugar", "30\%", "40\%", "30\%", "40\%", "30\%"),
      after = 1)
ht
merge_repeated_rows(ht)
merge_repeated_rows(ht, everywhere, "Type")
}
\seealso{
Other cell merging: 
\code{\link{merge_across}()},
\code{\link{merge_cells}()}
}
\concept{cell merging}
