% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-col-fns.R
\name{stripe}
\alias{stripe}
\alias{every}
\alias{everywhere}
\alias{evens}
\alias{odds}
\title{Return every n row or column numbers}
\usage{
stripe(n = 1, from = n)

everywhere(ht, dimension)

evens(ht, dimension)

odds(ht, dimension)
}
\arguments{
\item{n}{A number (at least 1)}

\item{from}{A number (at least 1)}

\item{ht}{An object with a \code{dim} attribute like a matrix or data frame.}

\item{dimension}{Number of the dimension to use.}
}
\description{
This is a convenience function to use in row or column specifications.
In this context,
\code{stripe(n, from)} will return \verb{from, from + n, ...,} up to the number of rows
or columns of the huxtable. \code{evens} and \code{odds} return even and odd
numbers, i.e. they are equivalent to \code{stripe(2, 2)} and \code{stripe(2, 1)} respectively.
\code{everywhere} returns all rows or columns, equivalently to \code{stripe(1)}.
}
\details{
Technically, \code{stripe} returns a 2-argument function which can be called like
\code{f(ht, dimension)}. See \link{rowspecs} for details.

Until huxtable 5.0.0, \code{stripe} was called \code{every}. It was renamed to
avoid a clash with \code{purrr::every}.
}
\examples{
ht <- huxtable(a = 1:10, b = 1:10)
set_background_color(
  ht,
  evens, everywhere,
  "grey95"
)
set_background_color(
  ht,
  stripe(3), everywhere,
  "grey95"
)

}
