% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_waterbody_centroids.R
\name{link_waterbody_centroids}
\alias{link_waterbody_centroids}
\title{Link geopoints to Waterbodies by centroids}
\usage{
link_waterbody_centroids(lats, lons, ids, dataset = c("nhdh", "nhdplusv2",
  "hydrolakes"), buffer = 25)
}
\arguments{
\item{lats}{Vector of point latitudes}

\item{lons}{Vector of point longitudes}

\item{ids}{Vector of point identifiers (string or numeric)}

\item{dataset}{Character name of dataset to link against. Can be either "nhd" or "hydrolakes"}

\item{buffer}{maximum distance between points and centroids to match}
}
\value{
Water body permanent IDs
}
\description{
Link geopoints to a waterbody with the closest centroid a geospatial dataset
}
\examples{
\dontrun{
centroidpt = c(33.655277, -117.834007)

#should be item ID 126859554
link_waterbody_centroids( centroidpt[1], centroidpt[2], 'dummyid', dataset='nhdh')
}

}
