% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_fromids.R
\name{make_fromids}
\alias{make_fromids}
\title{Convert "to" index ids to "from" index ids}
\usage{
make_fromids(index_ids, return_list = FALSE)
}
\arguments{
\item{index_ids}{data.frame as returned by \link{make_index_ids}}

\item{return_list}{logical if TRUE, the returned list will include a
"froms_list" element containing all from ids in a list form.}
}
\value{
list containing a "froms" matrix, "lengths" vector,
and optionally "froms_list" elements.
}
\description{
given a set of index ids as retrieved from \link{make_index_ids}
return an adjacency matrix with pointers to identifiers that flow to the
row of the matrix in question.
}
\examples{

x <- data.frame(id = c(1, 2, 3, 4, 5, 6, 7, 8, 9),
              toid = c(2, 3, 4, 5, 0, 7, 8, 9, 4))

y <- make_index_ids(x)

make_fromids(y)

}
