% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag.R
\name{get_lag_dir}
\alias{get_lag_dir}
\title{Get Lag from Input Directory}
\usage{
get_lag_dir(
  Q,
  relation,
  steplength = 15,
  lag.max = 20,
  na.action = na.pass,
  tz = "Etc/GMT-1",
  format = "\%Y.\%m.\%d \%H:\%M",
  cols = c(1, 2, 3),
  inputsep = ",",
  inputdec = ".",
  relation_pattern = "relation",
  save = FALSE,
  mc.cores = getOption("mc.cores", 2L),
  overwrite = FALSE
)
}
\arguments{
\item{Q}{Data frame or character string. If it is a data frame, it
corresponds to the \code{Q} data frame in
\code{\link[=get_lag]{get_lag()}}.  It contains at least a
column with the gauging station ID (default: column index 1), a
column with date-time values in character representation
(default: column index 2) and a column with flow rates
(default: column index 3). If the column indices differ from
\code{c(1, 2, 3)}, they have to be specified as \code{cols}
argument in the format \code{c(i, j, k)}. If it is a character
string, it contains the path to the corresponding file which is
then read within the function with
\code{\link[utils:read.csv]{utils::read.csv()}}.}

\item{relation}{A character string containing the path to the
directory where the relation files are located. They are read
within the function with
\code{\link[utils:read.csv]{utils::read.csv()}}.}

\item{steplength}{Numeric value that specifies the length between
time steps in minutes (default: \code{15} minutes). As time
steps have to be equispaced, this is used by
\code{\link[hydropeak:flow]{hydropeak::flow()}} to get a
compatible format and fill missing time steps with \code{NA}.}

\item{lag.max}{Maximum lag at which to calculate the ccf in
\code{\link[stats:ccf]{stats::ccf()}}.}

\item{na.action}{Function to be called to handle missing values in
\code{\link[stats:ccf]{stats::ccf()}} (default:
\code{na.pass}).}

\item{tz}{Character string specifying the time zone to be used for
internal conversion (default: \code{Etc/GMT-1}).}

\item{format}{Character string giving the date-time format of the
date-time column in the input data frame \code{Q}. This is
passed to \code{\link[hydropeak:flow]{hydropeak::flow()}}, to
get a compatible format (default: \code{YYYY.mm.dd HH:MM}).}

\item{cols}{Integer vector specifying column indices in the input
data frame which contain gauging station ID, date-time and flow
rate to be renamed. The default indices are 1 (ID), 2
(date-time) and 3 (flow rate, Q).}

\item{inputsep}{Field separator character string for input data.}

\item{inputdec}{Character string for decimal points in input data.}

\item{relation_pattern}{Character string containing a regular
expression to filter \code{relation} files (default: \code{relation}, to
filter files that contain \code{relation} with no restriction) (see
\code{\link[base:grep]{base::grep()}}).}

\item{save}{A logical. If \code{FALSE} (default) the lag, appended
to the relation file, overwrites the original \code{relation}
input file.}

\item{mc.cores}{Number of cores to use with
\code{\link[parallel:mclapply]{parallel::mclapply()}}. On
Windows, this will be set to 1.}

\item{overwrite}{A logical. If \code{FALSE} (default), it produces
an error if a \code{LAG} column already exists in the
\code{relation} file. Otherwise, it overwrites an existing
column.}
}
\value{
Returns invisible a list of data frames where each list
    element represents a \code{relation} file from the input
    directory. Optionally, the data frames overwrite the existing
    \code{relation} files with the appended \code{LAG} column.
}
\description{
Given a file path it reads a data frame (time series)
    of stage measurements. For each \code{relation} file in the
    provided directory path it calls
    \code{\link[=get_lag_file]{get_lag_file()}}.  Make sure that
    the file with Q data and the relation files have the same
    separator (\code{inputsep}) and character for decimal points
    (\code{inputdec}). Gauging station ID's in the \code{relation}
    files have to be in order of their location in downstream
    direction. The resulting lags are appended to the relation
    files. The resulting list of relation files can be returned and
    each relation file can be saved to its input path.
}
\examples{
Q_file <- system.file("testdata", "Q.csv", package = "hydroroute")
relations_path <- system.file("testdata", package = "hydroroute")
lag_list <- get_lag_dir(Q_file, relations_path, inputsep = ",",
                        inputdec = ".", format = "\%Y-\%m-\%d \%H:\%M",
                        overwrite = TRUE)
lag_list
}
