#' testdl
#'
#'A list containing different precipitation time series.
#'
#'
#' @format A list consists of 3 different lists.
#' \describe{
#'   \item{AAA}{AAA, a dataframe containing a date column and a value column. }
#'   \item{BBB}{BBB, a dataframe containing a date column and a value column.}
#'   \item{CCC}{CCC, a dataframe containing a date column and a value column.}
#'   ...
#' }
#' @references
#' \itemize{
#' \item http://meteo.navarra.es/estaciones/mapadeestaciones.cfm
#' \item #' http://www4.gipuzkoa.net/oohh/web/esp/02.asp
#' }
#' 
#' 
#' @source
#' http://meteo.navarra.es/estaciones/mapadeestaciones.cfm
#' http://www4.gipuzkoa.net/oohh/web/esp/02.asp
"testdl"


#' tgridData
#'
#'A list containing different information getting from grid data file, e.g., netcdf file.
#'
#'
#' @format A list containing different information.
#' \describe{
#'   \item{Variables}{variable information. }
#'   \item{Data}{Data.}
#'   \item{xyCoords}{longitude and latitude of the data.}
#'   \item{Dates}{Date information.}
#'   ...
#' }
#' @references 
#' 
#' \itemize{
#' \item Herrera, S., Ancell, R., Gutierrez, J. M., Pons, M. R., Frias, M. D., & Fernandez, J. 
#' (2012). Development and analysis of a 50-year high-resolution daily gridded precipitation dataset 
#' over Spain (Spain02). International Journal of Climatology 
#' (http://www.meteo.unican.es/datasets/spain02), 10.1002/joc.2256.
#' }
#' 
#' 
#' 
#' @source http://www.meteo.unican.es/datasets/spain02
"tgridData"



#' testCat
#' @format A catchment file generated by library sf.
#' \describe{
#'   \item{class}{Formal class 'SpatialPolygonsDataFrame' [package "sp"] with 5 slots}
#'   ...
#' }
"testCat"