% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.sel.poly.R
\name{map.sel.poly}
\alias{map.sel.poly}
\alias{sel.poly}
\title{Interactively select a polygon (grid graphics) and highlight points}
\usage{
map.sel.poly(data, pch = 19, size = 0.3, ...)

sel.poly(pch = 19, size = 0.3, ...)
}
\arguments{
\item{data}{hyperSpec object for plotting map or list returned by \code{\link{plotmap}}}

\item{pch}{symbol to display the points of the polygon for \code{\link{sel.poly}}}

\item{size}{size for polygon point symbol for \code{\link{sel.poly}}}

\item{...}{further arguments for \code{\link[grid]{grid.points}} and
\code{\link[grid]{grid.lines}}}
}
\value{
\code{map.sel.poly}: array of indices for points within the selected polygon

\code{sel.poly}: n x 2 matrix with the corner points of the polygon
}
\description{
Click the points that should be connected as polygon. Input ends with right click (see
\code{\link[grid]{grid.locator}}). Polygon will be drawn closed.
}
\details{
\code{map.sel.poly} is a convenience wrapper for \code{\link{plotmap}}, \code{sel.poly}, 
and \code{\link[sp]{point.in.polygon}}. For custiomized plotting, the plot can be produced by 
\code{\link{plotmap}}, \code{\link{plotvoronoi}} or \code{\link{levelplot}}, and the result of 
that plot command handed over to \code{map.sel.poly}, see the example below.

If even more customized plotting is required,\code{sel.poly} should be used (see example).
}
\examples{
if (interactive ()){
## convenience wrapper
map.sel.poly (chondro)

## customized version
data <- sample (chondro [,, 1004 - 2i ~ 1004 + 2i], 300)

plotdata <- plotvoronoi (data, clusters ~ y * x, col.regions = alois.palette ())
print (plotdata)
map.sel.poly (plotdata)

## even more customization:
plotvoronoi (data)

## interactively retrieve polygon
polygon <- sel.poly ()

## find data points within polygon
require ("sp")     
i.sel <- which (point.in.polygon (data$x, data$y, polygon [, 1], polygon [, 2]) > 0)

## work with selected points
grid.points (unit (data$x [i.sel], "native"), unit (data$y [i.sel], "native"))
}
}
\author{
Claudia Beleites, Sebastian Mellor

Claudia Beleites
}
\seealso{
\code{\link[grid]{grid.locator}}, \code{\link{map.identify}}

\code{\link[grid]{grid.locator}}
}
\keyword{iplot}

