% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spc.NA.approx.R
\name{spc.NA.approx}
\alias{spc.NA.approx}
\alias{spc.NA.linapprox}
\title{Impute missing data points}
\usage{
spc.NA.approx(spc, neighbours = 1, w = rep(1, 2 * neighbours), df = 1 +
  .Machine$double.eps, spar = NULL, debuglevel = hy.getOption("debuglevel"))

spc.NA.linapprox(...)
}
\arguments{
\item{spc}{hyperSpec object with spectra matrix containing \code{NA}s}

\item{neighbours}{how many neighbour data points should be used to fit the
line}

\item{w, df, spar}{see \code{\link[stats]{smooth.spline}}}

\item{debuglevel}{see \code{\link[hyperSpec]{options}}}

\item{...}{ignored}
}
\value{
hyperSpec object
}
\description{
Replace \code{NA}s in the spectra matrix by interpolation. With
less than 4 points available linear interpolation of the 2 neighbour points is used. For larger numbers of
neighbour points, smoothing interpolation is performed by
\code{\link[stats]{smooth.spline}}.
}
\note{
The function has been renamed from \code{spc.NA.linapprox} to  \code{spc.NA.approx}
}
\examples{
fluNA <- hyperSpec:::fluNA
spc.NA.approx (fluNA [,, min ~ 410], debuglevel = 1)
spc.NA.approx (fluNA [1,, min ~ 410], debuglevel = 2)
spc.NA.approx (fluNA [4,, min ~ 410], neighbours = 3, df = 4, debuglevel = 2)
}
\author{
Claudia Beleites
}
