% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i2dashboard.R
\docType{class}
\name{i2dashboard-class}
\alias{i2dashboard-class}
\alias{initialize,i2dashboard-method}
\alias{show,i2dashboard-method}
\alias{i2dashboard}
\title{The \linkS4class{i2dashboard} S4 class.}
\usage{
\S4method{initialize}{i2dashboard}(.Object, ...)

\S4method{show}{i2dashboard}(object)

i2dashboard(...)
}
\arguments{
\item{.Object}{An object of class \linkS4class{i2dashboard}.}

\item{...}{Named slots of the \linkS4class{i2dashboard} object.}

\item{object}{An \linkS4class{i2dashboard} class object.}
}
\value{
'\code{i2dashboard()}' returns an \linkS4class{i2dashboard} object with a default title, theme, and an empty 'default' page.

'\code{show()}' returns text, describing the structure of the \linkS4class{i2dashboard} object.
}
\description{
The \linkS4class{i2dashboard} S4 class provides main functionality of the package. Besides global properties such as the dashboard title, author and theme, an instance of the i2dashboard class also stores individual dashboard pages and the navigation menu, as well as all components that make up the content of individual pages. A new instance can be created using the \code{i2dashboard} function.
}
\section{Slots}{

\describe{
\item{\code{title}}{The dashboards title (default 'i2dashboard').}

\item{\code{author}}{The author of the dashboard.}

\item{\code{interactive}}{If a 'shiny'-based report should be created (default 'FALSE').}

\item{\code{theme}}{The theme of the dashboard (see the \href{https://pkgs.rstudio.com/flexdashboard/using.html#appearance}{documentation of 'flexdashboard'} for available themes) (default 'yeti').}

\item{\code{datadir}}{Path to the directory, where report data is stored (default 'tempdir()').}

\item{\code{pages}}{A list of dashboard pages.}

\item{\code{sidebar}}{Content of the global sidebar}

\item{\code{colormaps}}{A named list with color mappings.}

\item{\code{source}}{Either a logical value describing whether the source code should be embeded through an item in the navigation bar or a link to a URL where the source code can be found online.}

\item{\code{share}}{A vector with any number of the following services: 'facebook', 'twitter', 'google-plus', 'linkedin', and 'pinterest'. You can also specify “menu” to provide a generic sharing drop-down menu that includes all of the services.}

\item{\code{navbar}}{A list of links in the navigation bar (see the \href{https://pkgs.rstudio.com/flexdashboard/using.html#navigation_bar}{documentation of 'flexdashboard'}).}
}}

\examples{
\donttest{
dashboard <- i2dashboard()
dashboard <- i2dashboard(
    title = "Dashboard title",
    author = "John Doe",
    interactive = TRUE,
    theme = "cosmo",
    datadir = "path/to/workdir",
    source = "embed"
)
# inspect dashboard:
show(dashboard)
dashboard
}
}
