% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F005.stats.plot.R
\name{stats.plot}
\alias{stats.plot}
\title{Plot nGenes, UMIs and percent mito}
\usage{
stats.plot(
  x = NULL,
  plot.type = "box.umi",
  cell.color = "slategray3",
  cell.size = 1,
  cell.transparency = 0.5,
  box.color = "red",
  box.line.col = "green",
  back.col = "white",
  interactive = TRUE,
  out.name = "plot"
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{plot.type}{Choose from "box.umi", "box.mito", "box.gene", "box.s.phase", "box.g2m.phase","all.in.one", "point.mito.umi", "point.gene.umi".}

\item{cell.color}{Choose a color for points in the plot.}

\item{cell.size}{A number for the size of the points in the plot, default = 1.}

\item{cell.transparency}{Color transparency for points in "scatterplot" and "boxplot", default = 0.5.}

\item{box.color}{A color for the boxes in the "boxplot", default = "red".}

\item{box.line.col}{A color for the lines around the "boxplot", default = "green".}

\item{back.col}{Background color, default = "white"}

\item{interactive}{If set to TRUE an interactive HTML file will be created, default = TRUE.}

\item{out.name}{If "interactive" is set to TRUE, the out put name for HTML, default = "plot".}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and creates QC plot.
}
\examples{
stats.plot(demo.obj,
          plot.type = "all.in.one",
          out.name = "UMI-plot",
          interactive = FALSE,
          cell.color = "slategray3",
          cell.size = 1,
          cell.transparency = 0.5,
          box.color = "red",
          box.line.col = "green")
}
