\name{ttsAutoML}
\alias{ttsAutoML}

\encoding{latin1}

\title{Train time series by automatic machine learning of \code{h2o} provided by H2O.ai}

\description{
It generates  both the static and recursive time series plots of H2O.ai object generated by package \code{h2o} provided by H2O.ai.
}

\usage{
ttsAutoML(y,x=NULL,train.end,arOrder=2,xregOrder=0,maxSecs=30)
}

\arguments{
  \item{y}{
The time series vector of target variable, or the dependent variable, with \code{zoo} format, must have dimension. y can be either binary or continuous.
}

  \item{x}{ The time series matrix of input variables, or the independent variables, with \code{zoo} format.
}


  \item{train.end}{The end date of training data, must be specificed. The default dates of train.start and test.end are the start and the end of input data; and the test.start is the 1-period next of train.end.

}


\item{arOrder}{The autoregressive order of the target variable, which may be sequentially specifed like arOrder=1:5; or discontinuous lags like arOrder=c(1,3,5); zero is not allowed.

}

\item{xregOrder}{The distributed lag structure of the input variables, which may be sequentially specifed like xregOrder=1:5; or discontinuous lags like xregOrder=c(0,3,5); zero is allowed since contemporaneous correlation is allowed.

}

\item{maxSecs}{The maximal run time specified, in seconds. Default=20.

}



}


\details{

This function calls the h2o.automl function from package \code{h2o} to execute automatic machine learning estimation. When execution finished, it computes two types of time series forecasts: static and recursive. The procedure of h2o.automl automatically generates a lot of time features.
}



\value{

  \item{output}{Output object generated by train function of \code{caret}.}
  \item{arOrder}{The autoregressive order of the target variable used.}
  \item{data}{The dataset of imputed.}
  \item{dataused}{The data used by arOrder, xregOrder}

}


\author{
Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.

}

\examples{
# Cross-validation takes time, example below is commented.
data("macrodata")
dep<-macrodata[,"unrate",drop=FALSE]
ind<-macrodata[,-1,drop=FALSE]

# Choosing the dates of training and testing data
train.end<-"2008-12-01"

#autoML of H2O.ai

#autoML <- ttsAutoML(y=dep, x=ind, train.end,arOrder=c(2,4),
# xregOrder=c(0,1,3), maxSecs =30)
#testData2 <- window(autoML$dataused,start="2009-01-01",end=end(autoML$data))
#P1<-iForecast(Model=autoML,newdata=testData2,type="staticfit")
#P2<-iForecast(Model=autoML,newdata=testData2,type="recursive")

#tail(cbind(testData2[,1],P1))
#tail(cbind(testData2[,1],P2))


}

