% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Transportation}
\alias{Transportation}
\title{Britain Transportation Network}
\format{
A list of length 3, corresponding to the template graph, world graph, and
candidate data frame with first column indicating template node ID's and second column
indicating world node ID's.
The template graph and world graph are stored as lists of five adjacency matrices,
representing ferry, rail, metro, coach, and bus transportation connections respectively.
}
\usage{
data(Transportation)
}
\description{
The Britain Transportation Network reflects the transportation connections in
the UK, with five layers representing ferry, rail, metro, coach, and bus.
}
\details{
The data consists of a smaller template graph with 53 nodes and 56 connections
across five layers, a larger world graph with candidates of the template graph
with 2075 nodes and 8368 connections, and a list of candidate matches for each
template node, where the true correspondence is guaranteed to be among the candidates.

The template graph was constructed based on a random walk starting from a randomly
chosen hub node, a node that has connections in all the layers.
All edges in the template are common edges shared by two graphs, where 40\%, 24.1\%,
37.5\%, 31.7\% and 25.6\% of edges in the world graph are in template for each layer.
All graphs are unweighted, directed, and do not have self-loops.
}
\examples{
tm <- Transportation[[1]]
cm <- Transportation[[2]]
candidate <- Transportation[[3]]
tn <- nrow(tm[[1]])
wn <- nrow(cm[[1]])
similarity <- with(candidate, Matrix::sparseMatrix(i = tem, j = wor, x = 1,
                            dims = c(tn,wn)))
}
\references{
Gallotti, R., Barthelemy, M. (2015). \emph{The multilayer temporal
network of public transport in Great Britain.} Sci Data 2, 140056 .
https://doi.org/10.1038/sdata.2014.56.

J. D. Moorman, Q. Chen, T. K. Tu, Z. M. Boyd and A. L. Bertozzi, (2018).
\emph{Filtering Methods for Subgraph Matching on Multiplex Networks.} 2018 IEEE
International Conference on Big Data (Big Data), pp. 3980-3985,
doi: 10.1109/BigData.2018.8622566.
}
\seealso{
The original Britain Transportation Network data is found here
math.bu.edu/people/sussman/data/Transportation.rda.
The template graph and world graph in the `Transportation` data are
induced subgraphs of the original graphs , keeping only the candidate nodes.
}
\keyword{datasets}
