/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.FrechetDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class FrechetGen
extends RandomVariateGen {
    private double delta;
    private double beta;
    private double alpha;

    public FrechetGen(RandomStream s, double alpha) {
        this(s, alpha, 1.0, 0.0);
    }

    public FrechetGen(RandomStream s, double alpha, double beta, double delta) {
        super(s, new FrechetDist(alpha, beta, delta));
        this.setParams(alpha, beta, delta);
    }

    public FrechetGen(RandomStream s, FrechetDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getBeta(), dist.getDelta());
        }
    }

    public static double nextDouble(RandomStream s, double alpha, double beta, double delta) {
        return FrechetDist.inverseF(alpha, beta, delta, s.nextDouble());
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getDelta() {
        return this.delta;
    }

    protected void setParams(double alpha, double beta, double delta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        this.delta = delta;
        this.beta = beta;
        this.alpha = alpha;
    }
}

