% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstIndex.R
\name{ChaoSimpson}
\alias{ChaoSimpson}
\title{Estimation of Gini-Simpson index or Simpson diversity}
\usage{
ChaoSimpson(x, datatype = "abundance", transform = FALSE, conf = 0.95, B = 200)
}
\arguments{
\item{x}{a \code{matrix}, \code{data.frame} (species by sites), or \code{list} of species abundances or incidence frequencies. If \code{datatype = "incidence_freq"}, 
then the first entry of the input data must be total number of sampling units, followed by species incidence frequencies.}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}),
sampling-unit-based incidence frequencies data (\code{datatype = "incidence_freq"}) or species by sampling-units incidence matrix (\code{datatype = "incidence_raw"}).}

\item{transform}{a \code{logical} constant to compute traditional Gini-Simpson index (\code{transform=FALSE}) or the transformed Simpson diversity (\code{transform=TRUE}).}

\item{conf}{a positive number \eqn{\le} 1 specifying the level of confidence interval.}

\item{B}{an integer specifying the number of bootstrap replications.}
}
\value{
a data.frame of observed Gini-Simpson index/diversity, index/diversity estimator, s.e. and the associated confidence interval.
}
\description{
\code{ChaoSimpson}: estimation of Gini-Simpson index or the transformed Simpson diversity based on the methods proposed in Good (1953) and Chao et al. (2014)
}
\examples{
data(spider)
ChaoSimpson(spider$Girdled, datatype="abundance")
}
\references{
Chao, A., Gotelli, N.J., Hsieh, T.C., Sander, E.L., Ma, K.H., Colwell, R.K. & Ellison, A.M. (2014) Rarefaction and extrapolation with Hill numbers: a framework for sampling and estimation in species diversity studies. Ecological Monographs, 84, 45-67.\cr\cr 
Good, I.J. (1953) The population frequencies of species and the estimation of population parameters. Biometrika, 40, 237-264.
}
\seealso{
\code{\link{ChaoRichness}, \link{ChaoShannon}}
}
