% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iNZightTS.R
\name{inzightts}
\alias{inzightts}
\alias{inzightts.character}
\alias{inzightts.data.frame}
\alias{inzightts.ts}
\alias{inzightts.tbl_ts}
\title{Coerce data to an inzightts (time-series) object}
\usage{
inzightts(x, ...)

\method{inzightts}{character}(x, stringsAsFactors = TRUE, as.is = TRUE, ...)

\method{inzightts}{data.frame}(
  x,
  var = NULL,
  index = NULL,
  key = NULL,
  start = NULL,
  end = NULL,
  freq = NULL,
  ...
)

\method{inzightts}{ts}(x, var_name = NULL, pivot_longer = FALSE, ...)

\method{inzightts}{tbl_ts}(x, ...)
}
\arguments{
\item{x}{A \code{data.frame}, \code{ts}, tsibble, or path.}

\item{...}{Additional arguments to be passed to or from methods.}

\item{stringsAsFactors}{See \code{\link[utils]{read.csv}}}

\item{as.is}{See \code{\link[utils]{read.csv}}}

\item{var}{The column number or name in \code{data} representing the observations
used in the actual time series.}

\item{index}{The column number or name in \code{data} containing the time
variable.}

\item{key}{The variable(s) that uniquely determine time indices.}

\item{start}{The time of the first observation. It can be a single number or
a vector of two integers representing a natural time unit and
a (1-based) number of samples into the time unit.}

\item{end}{The time of the last observation, specified in the same way as
\code{start}.}

\item{freq}{The number of observations per unit of time.}

\item{var_name}{The new name for the variable column of the univariate time
series, applicable only if \code{x} is not an \code{mts} object.}

\item{pivot_longer}{Logical; set to \code{TRUE} to transform data to a "longer"
form, otherwise keep the current form. Applicable only if \code{x} is an
\code{mts} object.}
}
\value{
An \code{inzightts} (\code{inz_ts}) object, a sub-class of tsibble,
which includes the index variable, temporal variable, and, if
applicable, relevant keys.
}
\description{
The function \code{inzightts} creates temporal data frames for use in iNZight.
Unlike \code{ts} objects, these are tsibble objects that enable temporal data
wrangling, adapting to tidy data principles, which are both data- and
model-oriented.
}
\details{
If a \code{ts} object is used to create the inzightts object, all the domain
information is extracted from that object.

The \code{index} parameter should be a \code{character}, \code{Date},
\code{yearweek}, \code{yearmonth}, or \code{yearquarter} object.

If \code{index} is a \code{character}, the function recognizes the following
time variable formats without case sensitivity:
\itemize{
\item "(Y)yyyy": annually data, e.g., "(Y)1991"
\item "(Y)yyyyMmm": monthly data, e.g., "(Y)1991M01"
\item "(Y)yyyyQqq": quarterly data, e.g., "(Y)1991Q01"
\item "(Y)yyyyWww": weekly data with yearly seasonality, e.g., "(Y)1991W01"
\item "(Y)yyyyDdd": daily data with yearly seasonality, e.g., "(Y)1991D01"
\item "WwwDdd": daily data with weekly seasonality, e.g., "W01D01"
\item "DddHhh": hourly data with daily seasonality, e.g., "D01H01"
}

The length of digits of each time unit could be flexible, and spaces between
the time unit are allowed.

In case \code{data} is a data.frame or path to a \code{.csv} file, and
\code{start} is omitted, the starting date and the \code{freq} are extracted
from the column that includes the time information. This column is either
named \code{"Time"} or is the first column. If \code{end} is omitted, all of
the data will be used for the time-series.
}
\examples{
# create from a ts object
z <- inzightts(UKgas)
\dontrun{
plot(z)
}

# create from a data.frame
x <- inzightts(
    data.frame(Return = rnorm(100), Time = 1900:1999),
    var = "Return"
)
# or specify a time column
x <- inzightts(
    data.frame(Return = rnorm(100), Year = 1900:1999),
    var = "Return", index = "Year"
)

# create from a data.frame with modified time frame
y <- inzightts(
    data.frame(Return = rnorm(100)),
    start = c(1990, 1), end = c(1993, 5), freq = 12, var = 1
)
\dontrun{
plot(y)
}

}
\seealso{
\code{\link[tsibble]{tsibble}}, \code{\link[tsibble]{as_tsibble}}
and \code{\link[tsibble]{new_tsibble}}
}
