% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_survey.R
\name{import_survey}
\alias{import_survey}
\title{Import survey information from a file}
\usage{
import_survey(file, data)
}
\arguments{
\item{file}{the file containing survey information (see Details)}

\item{data}{optional, if supplied the survey object will be created with the supplied data.
Can be either a data.frame-like object, or a path to a data set which
will be imported using \code{iNZightTools::smart_read}.}
}
\value{
a \code{inzsvyspec} object containing the design parameters and, if data supplied,
the created survey object
}
\description{
The survey information should be in TOML format, with fields
corresponding to survey design components. For example,\preformatted{strata = strata_var
clusters = cluster_var
weights = wt_var
}
}
\details{
For replicate weight designs, vectors (if necessary) are declared with
square brackets, like so:\preformatted{repweights = ['w01', 'w02', 'w03', 'w04', ..., 'w20']
}

although this would be better expressed using a regular expression,\preformatted{repweights = '^w[0-2]'
}

which matches all variables starting with a \code{w} followed by digits between 0 and 2 (inclusive).

Additionally, the information can contain a \code{file} specification
indicating the path to the data, which will be imported using
\code{iNZightTools::smart_read} if it exists in the same directory
as \code{file}, or alternatively a URL to a data file that will be downloaded.
}
\author{
Tom Elliott
}
