% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{score.glmnetcv_learner}
\alias{score.glmnetcv_learner}
\title{Calculate the score for a GLMNet learner on the given data}
\usage{
\method{score}{glmnetcv_learner}(obj, X, ...)
}
\arguments{
\item{obj}{The learner or grid to evaluate.}

\item{X}{The features of the data.}

\item{...}{Other parameters, including zero or more target vectors as
required by the problem type. \code{fit_index} can be used to
specify the index of the fit in the path to use for prediction,
defaulting to the best fit if not supplied. Refer to the Julia
documentation for other available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.1/Heuristics/reference/#IAI.score-Tuple\%7BGLMNetCVLearner\%7D}{\code{IAI.score}}
}
\section{IAI Compatibility}{

Requires IAI version 2.1 or higher.
}

\examples{
\dontrun{iai::score(lnr, X, y, fit_index=1)}

}
