% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapAccessions.R
\name{mapAccessions}
\alias{mapAccessions}
\title{Plotting Accessions on Map.}
\usage{
mapAccessions(df, long, lat, y = NULL)
}
\arguments{
\item{df}{object of class "data.frame" with coordinates of accessions and target variable.}

\item{long}{character. Column name from \code{df} representing longitude.}

\item{lat}{character. Column name from \code{df} representing latitude.}

\item{y}{Default: NULL, column name from \code{df} representing the target variable.}
}
\value{
A world map with plotted points showing locations of accessions.
}
\description{
this function returns a map with points showing where accessions are located.
}
\examples{
if(interactive()){
 # Loading FIGS subset for wheat sodicity resistance
 data(FIGS)
 # World Map showing locations of accessions
 mapAccessions(df = FIGS, long = "Longitude", lat = "Latitude")
 
 # Map plotting locations of accessions with points coloured 
 # based on a gradient scale of SodicityIndex values
 mapAccessions(FIGS, long = "Longitude", lat = "Latitude", 
               y = "SodicityIndex")
 # Map plotting locations of accessions with points
 # coloured based on levels of y 
 mapAccessions(FIGS, long = "Longitude", lat = "Latitude", 
 y = "PopulationType")
 }
}
\author{
Khadija Aouzal, Zakaria Kehel
}
