% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelingSummary.R
\name{modelingSummary}
\alias{modelingSummary}
\title{Get modeling metrics}
\usage{
modelingSummary(
  data,
  y,
  p = 0.7,
  length = 10,
  control = "repeatedcv",
  number = 10,
  repeats = 10,
  process = c("center", "scale"),
  summary = multiClassSummary,
  positive,
  parallelComputing = FALSE,
  classtype,
  ...
)
}
\arguments{
\item{data}{object of class "data.frame" with target variable and predictor variables.}

\item{y}{character. Target variable.}

\item{p}{numeric. Proportion of data to be used for training. Default: 0.7}

\item{length}{integer. Number of values to output for each tuning parameter. If \code{search = "random"} is passed to \code{\link[caret]{trainControl}} through \code{...}, this becomes the maximum number of tuning parameter combinations that are generated by the random search. Default: 10.}

\item{control}{character. Resampling method to use. Choices include: "boot", "boot632", "optimism_boot", "boot_all", "cv", "repeatedcv", "LOOCV", "LGOCV", "none", "oob", timeslice, "adaptive_cv", "adaptive_boot", or "adaptive_LGOCV". Default: "repeatedcv". See \code{\link[caret]{train}} for specific details on the resampling methods.}

\item{number}{integer. Number of cross-validation folds or number of resampling iterations. Default: 10.}

\item{repeats}{integer. Number of folds for repeated k-fold cross-validation if "repeatedcv" is chosen as the resampling method in \code{control}. Default: 10.}

\item{process}{character. Defines the pre-processing transformation of predictor variables to be done. Options are: "BoxCox", "YeoJohnson", "expoTrans", "center", "scale", "range", "knnImpute", "bagImpute", "medianImpute", "pca", "ica", or "spatialSign". See \code{\link[caret]{preProcess}} for specific details on each pre-processing transformation. Default: c('center', 'scale').}

\item{summary}{expression. Computes performance metrics across resamples. For numeric \code{y}, the mean squared error and R-squared are calculated. For factor \code{y}, the overall accuracy and Kappa are calculated. See \code{\link[caret]{trainControl}} and \code{\link[caret]{defaultSummary}} for details on specification and summary options. Default: multiClassSummary.}

\item{positive}{character. The positive class for the target variable if \code{y} is factor. Usually, it is the first level of the factor.}

\item{parallelComputing}{logical. indicates whether to also use the parallel processing. Default: False}

\item{classtype}{integer.indicates the number of classes of the traits.}

\item{...}{additional arguments to be passed to \code{createDataPartition}, \code{trainControl} and \code{train} functions in the package \code{caret}.}
}
\value{
A dataframe contains the metrics of the modeling of five machine learning algorithms: KNN, SVM, RF, NNET, and Bcart.

\code{tuneTrain} relies on package \code{caret} to perform the modeling.
}
\description{
modelingSummary is an automatic function for modeling data, it returns a dataframe containing the metrics of the modeling using five machine learning algorithms: KNN, SVM, RF, NNET, and Bcart. This function is based on spliData, tuneTrain, predict, and getMetrics functions.
}
\details{
Types of classification and regression models available for use with \code{tuneTrain} can be found using \code{names(getModelInfo())}. The results given depend on the type of model used.
}
\examples{
if(interactive()){
 data(septoriaDurumWC)
 models <- modelingSummary(data = septoriaDurumWC, y = "ST_S", positive = "R", classtype = 2)
}
}
\seealso{
\code{\link[caret]{createDataPartition}},
 \code{\link[caret]{trainControl}},
 \code{\link[caret]{train}},
 \code{\link[caret]{predict.train}},
 \code{\link[caret]{confusionMatrix}}
}
\author{
Zakaria Kehel, Khadija Aziz
}
