% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_comorbid.R, R/z-deprecated.R
\name{diff_comorbid}
\alias{diff_comorbid}
\alias{diff_comorbid.list}
\alias{icd_diff_comorbid.list}
\alias{icd_diff_comorbid}
\title{show the difference between two comorbidity mappings}
\usage{
diff_comorbid(x, y, all_names = NULL, x_names = NULL, y_names = NULL,
  show = TRUE, explain = TRUE)

\method{diff_comorbid}{list}(x, y, all_names = NULL, x_names = NULL,
  y_names = NULL, show = TRUE, explain = TRUE)

icd_diff_comorbid.list(...)

icd_diff_comorbid(...)
}
\arguments{
\item{x}{list of character vectors}

\item{y}{list of character vectors}

\item{all_names}{character vector of the comorbidity names}

\item{x_names}{character vector of the comorbidity names from \code{x} to
compare}

\item{y_names}{character vector of the comorbidity names from \code{y} to
compare}

\item{show}{single logical value. The default is \code{TRUE} which causes a
report to be printed.}

\item{explain}{single logical value. The default is \code{TRUE} which means
the differing codes are attempted to be reduced to their parent codes, in
order to give a more succinct summary.}

\item{...}{arguments passed on to other functions}
}
\value{
A list, each item of which is another list containing the
  intersections and both asymmetric differences.
}
\description{
Compares two comorbidity to ICD code mappings. The results are returned
invisibly as a list. Only those comorbidities with (case sensitive)
overlapping names are compared.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: Show difference between comorbidity maps with
ICD-9 codes
}}

\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.

 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\examples{
# compare CHF for ICD-10 mappings from Elixhauser and AHRQ
diff_comorbid(icd10_map_elix, icd10_map_ahrq, show = FALSE)[["CHF"]]
\dontrun{
# default is to show the results in a human readable manner:
diff_result <- diff_comorbid(icd9_map_elix, icd9_map_ahrq)[["CHF"]]
# show differences for
# give full report on all comorbidities for these mappings
diff_result <- diff_comorbid(icd9_map_elix, icd9_map_ahrq, show = FALSE)

# the following outputs a summary to the console:
diff_comorbid(icd9_map_elix, icd9_map_ahrq)
}
}
