% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/factor_nosort.R
\name{factor_nosort_rcpp_worker}
\alias{factor_nosort_rcpp_worker}
\alias{factor_nosort}
\alias{factor_nosort_rcpp}
\title{Fast Factor Generation}
\usage{
factor_nosort_rcpp_worker(x, levels, na_rm)

factor_nosort(x, levels)

factor_nosort_rcpp(x, levels, na.rm = FALSE)
}
\arguments{
\item{x}{An object of atomic type \code{integer}, \code{numeric},
\code{character} or \code{logical}.}

\item{levels}{An optional character vector of levels. Is coerced to the same
type as \code{x}. By default, we compute the levels as
\code{sort(unique.default(x))}.}

\item{na.rm}{Logical, if \code{TRUE}, simple drop all NA values, i.e., values with
no corresponding level.}

\item{labels}{A set of labels used to rename the levels, if desired.}
}
\description{
This function generates factors more quickly, without leveraging
\pkg{fastmatch}. The speed increase with \pkg{fastmatch} for ICD-9 codes
was about 33% reduction for 10 million codes. SOMEDAY could be faster still
using \pkg{Rcpp}, and a hashed matching algorithm.
}
\details{
\code{NaN}s are converted to \code{NA} when used on numeric values. Extracted
from https://github.com/kevinushey/Kmisc.git

These feature from base R are missing: \code{exclude = NA, ordered =
is.ordered(x), nmax = NA}

I don't think there is any requirement for factor levels to be
  sorted in advance, especially not for ICD-9 codes where a simple
  alphanumeric sorting will likely be completely wrong.
}
\section{Functions}{
\itemize{
\item \code{factor_nosort_rcpp_worker}: \pkg{Rcpp} implementation, requiring character
vector inputs only, no argument checking.

\item \code{factor_nosort_rcpp}: R wrapper to the \pkg{Rcpp} function. Will
re-factor a factor with new levels without converting to string vector.
}}

\examples{
x <- c("z", "a", "123")
icd:::factor_nosort(x)
# should return a factor without modification
x <- as.factor(x)
identical(icd:::factor_nosort(x), x)
# unless the levels change:
icd:::factor_nosort(x, levels = c("a", "z"))

# existing factor levels aren't re-ordered without also moving elements
f <- factor(c("a", "b", "b", "c"))
g <- icd:::factor_nosort(f, levels = c("a", "c", "b"))
stopifnot(g[4] == "c")
}
\author{
Kevin Ushey, adapted by Jack Wasey
}
\keyword{internal}
\keyword{manip}
