% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ExpandRangeShort}
\alias{\%i9s\%}
\alias{icd9ExpandRangeShort}
\title{take SAS icd9 format for character range and expand to a list of codes}
\usage{
icd9ExpandRangeShort(start, end, validate = FALSE)

start \%i9s\% end
}
\arguments{
\item{start,end}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{validate}{logical whether to validate the input ICD-9 codes for
correctness. There may be additional simple checks, e.g. whether the code
is of the right type, regardless of this argument.}
}
\description{
this is cumbersome code, covering a whole load of edge cases
  relating to the fact that icd9 codes are \strong{not} in numeric order. An
  alternative strategy would be to list all the ICD9 codes, then a range
  would just pick out start and finish positions, and return subset of the
  list. Not all ICD-9 codes are valid, including some parent codes which have
  valid children. However, I expect at least some of these have been used in
  some billing databases.
}
\examples{
"4280 " \%i9s\% "4289 "
"V80 " \%i9s\% " V8210 "

# the following should give all codes in 428 EXCEPT "428",
# and all codes upto 43014 EXCEPT 430 and 4301
icd9ExpandRangeShort("4280 ", "43014")
}

