% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/score.R
\name{icd9Count}
\alias{icd9Count}
\alias{icd9CountComorbidBin}
\alias{icd9CountWide}
\title{count icd9 codes or comorbidities for each patient}
\usage{
icd9Count(x, visitId = NULL, return.df = FALSE)

icd9CountComorbidBin(x, visitId = NULL, return.df = FALSE)

icd9CountWide(x, visitId = NULL, return.df = FALSE, aggregate = FALSE)
}
\arguments{
\item{x}{data frame with one row per patient, and a true/false or 1/0 flag
for each column. By default, the first column is the patient identifier and
is not counted. If \code{visitId} is not specified, the first column is
used.}

\item{visitId}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. Defaults to "visitId"}

\item{return.df}{single logical, if \code{TRUE}, return the result as a data
frame with the first column being the \code{visitId}, and the second being
the count. If \code{visitId} was a factor or named differently in the
input, this is preserved.}

\item{aggregate,}{single logical, default is FALSE. If TRUE, the length (or
rows) of the output will no longer match the input, but duplicate visitIds
will be counted together.}
}
\value{
vector of the count of comorbidities for each patient. This is
  sometimes used as a metric of comorbidity load, instead of, or inaddition
  to metrics like the Charlson Comorbidity Index (aka Charlson Score)
}
\description{
\code{icd9Count} takes a data frame with a column for
  \code{visitId} and another for ICD-9 code, and returns the number of
  distinct codes for each patient.

  The visitId field is typically the first column. If there is no column
  called \code{visitId} and \code{visitId} is not specified, the first column
  is used.

\code{icd9CountComorbidBin} differs from the other counting
  functions in that it counts _comorbidities_, not individual diagnoses. It
  accepts any data frame with either logicals or zero/non-zero contents, with
  a single column for visitId. No checks are made to see whether visitId is
  duplicated.

For \code{icd9Count}, it is assumed that all the columns apart
  from \code{vistiId} represent actual or possible ICD-9 codes. Duplicate
  \code{visitId}s are repeated as given and aggregated.
}
\details{
TODO: optionally check each code is valid before counting.
}
\examples{
mydf <- data.frame(visitId = c("r", "r", "s"),
                   icd9 = c("441", "412.93", "044.9"))
  icd9Count(mydf, return.df = TRUE)
  icd9Count(mydf)

  cmb <- icd9ComorbidQuanDeyo(mydf, isShort = FALSE)
  icd9CountComorbidBin(cmb)

  wide <- data.frame(visitId = c("r", "s", "t"),
                   icd9_1 = c("0011", "441", "456"),
                   icd9_2 = c(NA, "442", NA),
                   icd9_3 = c(NA, NA, "510"))
  icd9CountWide(wide)
  # or:
  library(magrittr)
  wide \%>\% icd9WideToLong \%>\% icd9Count
}

