% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convert.R
\name{icd9WideToLong}
\alias{icd9WideToLong}
\title{convert ICD data from wide to long format}
\usage{
icd9WideToLong(x, visitId = NULL, icdLabels = NULL, icdName = "icdCode")
}
\arguments{
\item{x}{\code{data.frame} in wide format, i.e. one row per patient, and
multiple columns containing ICD codes, empty strings or NA.}

\item{visitId}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. Defaults to "visitId"}

\item{icdLabels}{vector of column names in which codes are found. If NULL,
all columns matching icd or ICD will be included.}

\item{icdName}{character vector length one containing the new column name
for the ICD codes, defaults to "icdCode"}
}
\value{
data frame with visitId column named the same as input, and a column
  named by \code{icd.name} containing all the non-NA and non-empty codes
  found in the wide input data.
}
\description{
This is different enough to \code{dcast} in \code{reshape2} that
  it needs writing again specifically for ICD codes. This function packages
  the core \code{reshape} function. Empty strings and NA values will be
  dropped, and everything else kept. No validation of the ICD codes is done.
}
\examples{
widedf <- data.frame(visitId = c("a", "b", "c"),
    icd9_01 = c("441", "4424", "441"),
    icd9_02 = c(NA, "443", NA))
  icd9WideToLong(widedf)
}
\seealso{
Other ICD-9 convert: \code{\link{convert}},
  \code{\link{convert}}, \code{\link{icd9DecimalToParts}},
  \code{\link{icd9DecimalToShort}},
  \code{\link{icd9GetMajor}},
  \code{\link{icd9MajMinToCode}},
  \code{\link{icd9MajMinToDecimal}},
  \code{\link{icd9MajMinToParts}},
  \code{\link{icd9MajMinToShort}},
  \code{\link{icd9PartsToDecimal}},
  \code{\link{icd9PartsToShort}},
  \code{\link{icd9ShortToDecimal}},
  \code{\link{icd9ShortToParts}};
  \code{\link{icd9ChaptersToMap}};
  \code{\link{icd9DropLeadingZeroes}},
  \code{\link{icd9DropLeadingZeroesDecimal}},
  \code{\link{icd9DropLeadingZeroesMajor}},
  \code{\link{icd9DropLeadingZeroesShort}};
  \code{\link{icd9LongToWide}}
}

