% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/filter.R
\name{icd9FilterInvalid}
\alias{icd9FilterInvalid}
\title{Filter ICD-9 codes by invalidity.}
\usage{
icd9FilterInvalid(icd9df, icd9Field = NULL, isShort = NULL,
  invert = FALSE)
}
\arguments{
\item{icd9df}{data frame containing columns for visitId (which is the feault
name), icd9 (default for the icd9 code), and  maybe also a POA flag.}

\item{icd9Field}{The column in the data frame which contains the ICD codes.
This is a character vector of length one. If it is \code{NULL}, \code{icd9}
will attempt to guess the column name, looking for progressively less
likely possibilities until it matche a single column. Failing this, it will
take the first column in the data frame. Specifying the column using this
argument avoids the guesswork.}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{invert}{single logical value, if TRUE will return valid instead of invalid rows.}
}
\description{
Filters a data.frame of patients for valid or invalid ICD-9 codes
}

