% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_np.R
\name{ic_np}
\alias{ic_np}
\title{Non-Parametric Estimator for Interval Censored Data}
\usage{
ic_np(formula = NULL, data, maxIter = 1000, tol = 10^-10, B = c(0,
  1), weights = NULL)
}
\arguments{
\item{formula}{Formula for stratification. If only one group, can be left blank and 
data must be entered as n x 2 matrix.}

\item{data}{A \code{data.frame} or an n x 2 matrix. See details.}

\item{maxIter}{Maximum iterations}

\item{tol}{Numeric tolerance}

\item{B}{Should intervals be open or closed? See details.}

\item{weights}{Weights (optional)}
}
\description{
Fits the non-parametric maximum likelihood estimator (NPMLE) for univariate interval censored data. 
 This is a generalization of the Kaplan-Meier curves that allows for interval censoring. 
 Also referred to as the Turnbull estimator.
}
\details{
\code{data} must be an n x 2 matrix or data.frame containing two columns of data representing 
left and right sides of the censoring interval, denoted L and R. This allows for left censored 
(L == 0), right censored (R == inf), uncensored (L == R) along with general interval censored observations. 

The argument \code{B} determines whether the intervals should be open or closed, i.e. 
\code{B = c(0,1)} implies that the event occurs within the interval \code{(l,u]}. 
The exception is that if \code{l == u}, it is assumed that the event is uncensored, regardless of \code{B}.

The NPMLE is fit using an efficient implementation of the EMICM algorithm.
}
\examples{
data(miceData)
fit <- ic_np(cbind(l, u) ~ grp, data = miceData)
# Stratifies fits by group

plot(fit) 
}
\references{
Turnbull, B. (1976) The empricial distribution with arbitrarily grouped and censored data 
\emph{Journal of the Royal Statistical Society B}, vol 38 p290-295

Wellner, J. A., and Zhan, Y. (1997) A hybrid algorithm for computation of the maximum likelihood estimator 
from censored data, \emph{Journal of the  American Statistical Association}, Vol 92, pp945-959

Anderson-Bergman, C. (2016) An efficient implementation of the EMICM algorithm for the interval censored NPMLE
\emph{Journal of Computational and Graphical Statistics}, \emph{just accepted}
}
\author{
Clifford Anderson-Bergman
}
