% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSAGGraphs.R
\name{getSAGGraphs}
\alias{getSAGGraphs}
\title{Get a Summary Table of Historical Stock Size}
\usage{
getSAGGraphs(key)
}
\arguments{
\item{key}{the unique identifier of the stock assessment}
}
\value{
An array representing a png.
}
\description{
Get a summary table of historical stock size, recruitment, and fishing pressure.
}
\examples{
key <- findKey("cod", 2015)
graphs <- getSAGGraphs(key[1])
plot(graphs)

}
\author{
Colin Millar and Scott Large.
}
\seealso{
\code{\link{getListStocks}} gets a list of stocks.

\code{\link{getFishStockReferencePoints}} gets biological reference points.

\code{\link{icesSAG-package}} gives an overview of the package.
}

