#' @docType package
#'
#' @name icesSAG-package
#'
#' @aliases icesSAG
#'
#' @title Stock Assessment Graphs Database Web Services
#'
#' @description
#' R interface to access the web services of the ICES Stock Assessment Graphs
#' database.
#'
#' @details
#' \emph{Get dataset:}
#' \tabular{ll}{
#'   \code{\link{getSummaryTable}}             \tab summary results\cr
#'   \code{\link{getFishStockReferencePoints}} \tab reference points\cr
#'   \code{\link{getSAG}}                      \tab any data
#' }
#' \emph{Look up codes:}
#' \tabular{ll}{
#'   \code{\link{findAssessmentKey}}       \tab find assessment key\cr
#'   \code{\link{getListStocks}} \tab list of stocks
#' }
#'
#' @author Colin Millar, Scott Large, and Arni Magnusson.
#'
#' @references
#' ICES Stock Assessment Graphs database: \url{http://sg.ices.dk}.
#'
#' ICES Stock Assessment Graphs web services:
#' \url{http://sg.ices.dk/webservices.aspx}.

NA
