% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getsetSettingsForAStock.R
\name{getsetSAGSettingsForAStock}
\alias{getsetSAGSettingsForAStock}
\alias{getSAGSettingsForAStock}
\alias{setSAGSettingForAStock}
\title{Get and set SAG chart settings}
\usage{
getSAGSettingsForAStock(assessmentKey)

setSAGSettingForAStock(assessmentKey, chartKey, settingKey, settingValue,
  copyNextYear)
}
\arguments{
\item{assessmentKey}{the unique identifier of the stock assessment}

\item{chartKey}{the type identifier of the SAG chart, e.g. 0, 1, 2, ...}

\item{settingKey}{the type identifier of the SAG chart setting, e.g. 0, 1, 2, ...}

\item{settingValue}{the vale of the setting}

\item{copyNextYear}{should the settings be copied to next year (TRUE) or not (FALSE)}
}
\value{
a data.frame with SAG chart type IDs, settings IDs and setting values.
}
\description{
details
}
\examples{
key <- findAssessmentKey("cod.347d", 2016)
getSAGSettingsForAStock(key)

}
