% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeAll.R
\name{makeAll}
\alias{makeAll}
\title{Run All TAF Scripts as Needed}
\usage{
makeAll(path = ".", ...)
}
\arguments{
\item{path}{directory containing TAF scripts.}

\item{\dots}{passed to \code{\link{make}}.}
}
\value{
Logical vector indicating which scripts were run.
}
\description{
Run TAF scripts that have changed, or if previous steps were rerun.
}
\note{
TAF scripts that will be run as needed: \code{data.R}, \code{input.R},
\code{model.R}, \code{output.R}, and \code{report.R}.
}
\examples{
\dontrun{
makeAll()
}

}
\seealso{
\code{\link{source}} runs any R script, \code{\link{sourceTAF}} is more
convenient for running a TAF script, and \code{\link{sourceAll}} runs all TAF
scripts.

\code{\link{make}}, \code{\link{makeTAF}}, and \code{\link{makeAll}} are
similar to the \code{source} functions, except they avoid repeating tasks
that have already been run.

\code{\link{icesTAF-package}} gives an overview of the package.
}
