% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtab2taf.R
\name{xtab2taf}
\alias{xtab2taf}
\title{Convert Crosstab Table to TAF Format}
\usage{
xtab2taf(x, colname = "Year")
}
\arguments{
\item{x}{a data frame in crosstab format.}

\item{colname}{name for first column.}
}
\value{
A data frame in TAF format.
}
\description{
Convert a table from crosstab format to TAF format.
}
\note{
TAF stores tables as data frames, usually with a year column as seen in stock
assessment reports. The crosstab format can be more convenient for analysis
and producing plots.
}
\examples{
xtab2taf(catage.xtab)

}
\seealso{
\code{\link{catage.taf}} and \code{\link{catage.xtab}} describe the TAF and
crosstab formats.

\code{\link{taf2xtab}} converts a TAF table to crosstab format.

\code{\link{icesTAF-package}} gives an overview of the package.
}
