% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download}
\alias{download}
\title{Download File}
\usage{
download(url, dir = ".", mode = "wb", chmod = file_ext(url) == "",
  destfile = file.path(dir, basename(url)), quiet = TRUE, ...)
}
\arguments{
\item{url}{URL of file to download.}

\item{dir}{directory to download to.}

\item{mode}{download mode, see details.}

\item{chmod}{whether to set execute permission (default is \code{TRUE} if
file has no filename extension).}

\item{destfile}{destination path and filename (optional, overrides
\code{dir}).}

\item{quiet}{whether to suppress messages.}

\item{\dots}{passed to \code{download.file}.}
}
\description{
Download a file in binary mode, e.g. a model executable.
}
\details{
With the default mode \code{"wb"} the file is downloaded in binary mode (see
\code{\link{download.file}}), to prevent R from adding \verb{^M} at line
ends. This is particularly relevant for Windows model executables, while the
\code{chmod} switch is useful when downloading Linux executables.

This function can be convenient for downloading any file, including text
files. Data files in CSV or other text format can also be read directly into
memory using \code{read.table}, \code{read.taf} or similar functions, without
writing to the file system.
}
\note{
If \code{destfile} contains a question mark it is removed from the
\code{destfile} filename. Similarly, if \code{destfile} contains spaces or
\file{\%20} sequences, those are converted to underscores.

In general, TAF scripts do not access the internet using
\code{download} or similar functions. Instead, data and software are declared
in DATA.bib and SOFTWARE.bib and then downloaded using
\code{\link{taf.bootstrap}}. The exception is when a bootstrap script is used
to fetch files from a web service (see
\href{https://github.com/ices-taf/doc/wiki/Bib-entries}{TAF Wiki}).
}
\examples{
\dontrun{
url <- paste0("https://github.com/ices-taf/2015_had-iceg/raw/master/",
              "bootstrap/initial/software/catageysa.exe")
download(url)
}

}
\seealso{
\code{\link{download.file}} is the underlying base function to download
files.

\code{\link{download.github}} downloads a GitHub repository.

\code{\link{icesTAF-package}} gives an overview of the package.
}
