% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{df_trim}
\alias{df_trim}
\title{Trim Dataframe Rows with NA Values}
\usage{
df_trim(x)
}
\arguments{
\item{x}{the data.frame to trim.}
}
\value{
The data.frame 'x' with rows containing NA values removed.
}
\description{
Trim rows containing NA values from a 'data.frame' object. An efficient
    version of \code{stats::na.omit()} with no data validation or checking.
}
\details{
Works only where the columns contain atomic (e.g. numeric) and not
    recursive types (e.g. lists).
}
\examples{
data <- data.frame(c(1:4, NA), c(NA, 2:5))
data
df_trim(data)

}
