% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mltools.R
\name{mlgrid}
\alias{mlgrid}
\title{mlgrid Numeric Representation}
\usage{
mlgrid(
  x,
  y = c("logret", "ret", "none"),
  k = 1L,
  dir = c("long", "short"),
  type = c("boolean", "numeric", "z-score"),
  format = c("dataframe", "matrix"),
  unique = TRUE,
  func = list()
)
}
\arguments{
\item{x}{an ichimoku object.}

\item{y}{[default 'logret'] choose target variable 'logret' (log returns),
'ret' (discrete returns), or 'none'.}

\item{k}{[default 1L] number of periods time horizon over which to calculate
target variable 'y'.}

\item{dir}{[default 'long'] trade direction, either 'long' or 'short'.}

\item{type}{[default 'boolean'] choose 'boolean', 'numeric' or 'z-score'.
'boolean' creates a grid of dummy variables for ichimoku indicator
conditions of the form 1 if c1 > c2, 0 otherwise. 'numeric' creates a
grid of the numeric difference c1 - c2. 'z-score' standardises the numeric
grid by the mean and standard deviation of each feature.}

\item{format}{[default 'dataframe'] select either 'dataframe' or 'matrix' for
the format of returned object.}

\item{unique}{[default TRUE] to return only unique combinations of c1 and c2.
Set to FALSE to return both c1 > c2 and c2 > c1.}

\item{func}{[default list()] (for advanced use only) a named list of
functions which take 2 arguments: 'core' and 'xlen', the coredata matrix
of the ichimoku object and the number of observations, respectively. Each
function must return a vector of length 'xlen', and these are included in
the grid.}
}
\value{
A data.frame or matrix in a 'tidy' format with one observation per
    row and one feature per column with the target 'y' as the first column
    (unless set to 'none').

    The 'y' and 'k' parameters, trade direction and grid type are set as
    attributes, with 'means' and 'sdevs' also populated for type 'z-score' to
    return the mean and standard deviation for each column. To view these,
    use \code{\link{look}} on the returned object.
}
\description{
Create a grid of ichimoku indicator conditions and next period returns. The
    grid facilitates the comparison of strategy returns and provides a basis
    for use in machine learning applications. Translates the visual
    representation of the relationship between cloud chart elements into a
    numerical format for further analysis.
}
\details{
The date-time index corresponds to when the indicator condition is
    met at the close for that period. The return is the k-period return
    achieved by transacting at the immediately following opening price until
    the next opening price.

    Only valid combinations are included. This excludes any combination
    involving 'open' as it is in effect a lagged indicator and not
    contemporaneous. The following trivial or highly-collinear pairs are also
    excluded: (high, close), (low, close), (low, high), (cloudTop, Senkou A),
    (cloudBase, senkou A), (cloudTop, senkouB), (cloudBase, senkouB),
    (cloudBase, cloudTop).
}
\section{Further Details}{


    Please refer to the strategies vignette by calling:
    \code{vignette("strategies", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
grid <- mlgrid(cloud, y = "ret", k = 2, dir = "short", type = "z-score")
str(grid)

}
\seealso{
\code{\link{autostrat}} which uses \code{mlgrid()} to enumerate all
    valid return combinations.

    \code{\link{relative}} which uses \code{mlgrid()} to relate the latest
    observed numeric representation to historical values.
}
