% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportHudgens.R
\name{existenceNPMLE}
\alias{existenceNPMLE}
\title{Check existence of NPMLE}
\usage{
existenceNPMLE(intervals, supportdf)
}
\arguments{
\item{intervals}{A data.frame with 4 columns containing half-open intervals (left open, right closed)
and an indicator whether the interval results from a censored transition
 or truncation:
\describe{
  \item{\code{L}:}{Left side of interval;}
  \item{\code{R}:}{Right side of interval;}
  \item{\code{cens}:}{Indicator whether interval resulted from censoring or truncation
  (1 = censoring, 0 = truncation);}
  \item{\code{id}:}{(required) Identifier for the observation this interval belongs to (numeric/integer);}
} Note that the truncation intervals need to be in the form (N, Inf] with N a numeric value.}

\item{supportdf}{A data from containing 2 columns indicating the support intervals:
\describe{
  \item{\code{L}:}{Left side of interval;}
  \item{\code{R}:}{Right side of interval;}
}}
}
\description{
Using Theorem 1 from Hudgens (2005) we can check whether an 
NPMLE exists. This procedure is implemented in this function.
}
\keyword{internal}
