% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate.R
\name{id_make}
\alias{id_make}
\title{Create data to run IRT model}
\usage{
id_make(score_data = NULL, simul_data = NULL, person_cov = NULL,
  item_cov = NULL, item_cov_miss = NULL, person_data = NULL,
  item_data = NULL, miss_val = NA, high_val = 3L, low_val = 1L,
  middle_val = 2L, ordinal = TRUE, time = NULL,
  outcome_label_type = "votes", exclude_level = NULL, inflate = TRUE,
  simulation = FALSE, include_pres = FALSE)
}
\arguments{
\item{score_data}{Your person-item (legislator-bill) matrix in which persons (legislators) are in rows and 
items (bills) are in columns. The cells of the matrix should contain consecutive integers \eqn{1,...K} for 
ordinal \eqn{K} outcomes or integers \eqn{[0,1]} for a binary outcome in which 0 equals no (or incorrect) and 
1 equals yes (or correct). If absences/missing data are included, they should be coded as the highest category \eqn{K+1} for
ordinal outcomes and 2 for binary outcomes.}

\item{simul_data}{Optionally, data that has been generated by the \code{\link{id_sim_gen}} function.}

\item{person_cov}{A matrix of person (legislator) covariates for hierarchical modeling. If multiple time points are used, then should be a 
multi-column matrix with one column for each time point.}

\item{item_cov}{A one-column matrix of item (bill) covariates for hierarchical modeling of item (bill) discrimination parameters in the non-inflated model, i.e., non-missing model}

\item{item_cov_miss}{A one-column matrix of item (bill) covariates for hierarchical modeling of item (bill) discrimination parameters in the inflated model (missing data model)}

\item{person_data}{An optional data frame of information about the persons (legislators). Should include a \code{person.names} column containing names of
persons (legislators) and optionally a \code{group} column with names of any groupings of the persons (legislators), such as parties or blocs (used for visualization).}

\item{item_data}{An optional data frame of item/bill labels and other information used for visualization. Should include \code{item.names} column 
containing item/bill labels; other columns are optional.}

\item{miss_val}{The value (numeric or character) that indicate missing data/absences in the data. If there are multiple possible values, 
pass along a numeric or character vector of all such values. If missing data is coded as \code{NA}, simply leave this parameter at the default, \code{NA}.}

\item{high_val}{The value (numeric or character) that indicate the highest ordinal outcome possible, such as yes in a vote dataset or correct in a test examination.
If there are multiple possible values, 
pass along a numeric or character vector of all such values.}

\item{low_val}{The value (numeric or character) that indicates the lowest ordinal outcome possible, such as no votes in a vote dataset or incorrect in a test examination.
If there are multiple possible values, 
pass along a numeric or character vector of all such values.}

\item{middle_val}{The value (numeric or character) that indicate values between the lowest and highest categories, such as abstention in voting data or "Neither Agree nor Disagree" in likert scales.
If there are multiple possible values, 
pass along a numeric or character vector of all such values in correct order (lower to higher values).
If there are no middle values (binary outcome), set to \code{NULL}.}

\item{ordinal}{Whether or not the data contain ordinal responses. If \code{TRUE}, middle values/abstentions are used as a middle category in constructing the outcome.
Otherwise the response is assumed to be binary (yes/no) or (correct/incorrect).}

\item{time}{An optional integer vector of length equal to the number of columns in the response matrix (i.e., the number of items or bills)
that indicates for each item/bill which time point that item/bill belongs to. This time vector is only used for models in which person/legislator
ideal points are allowed to vary over time.}

\item{outcome_label_type}{Whether to use pre-set labels for the outcome values. If set to \code{bills}, the default, will label the outcome as \code{c('No','Abstain','Yes','Absent')} if there are 3 possible categories.
Otherwise, either pass \code{NULL} to this option to use integers for labels or a character vector equal to the number of categories in the
outcome. Used for visualization.}

\item{exclude_level}{A vector of any values that should be treated as \code{NA} in the response matrix. Unlike the \code{middle_val} parameter, these values will be dropped from the data before estimation rather than modeled explicitly.}

\item{inflate}{If \code{TRUE}, the score matrix is set up to enable modeling of missing data/absences (\code{miss_val}) as an inflation model in \code{\link{id_estimate}}}

\item{simulation}{If \code{TRUE}, simulated values are saved in the \code{idealdata} object for later plotting with the \code{\link{id_plot_sims}} function}

\item{include_pres}{If \code{FALSE} and \code{score_data} is a \code{rollcall} object, drop the first row which often represents tiebreaker votes cast by the Vice President in the US Senate.}
}
\value{
A \code{idealdata} object that can then be used in the \code{\link{id_estimate}} function to fit a model.
}
\description{
To run an IRT model using \code{idealstan}, you must first process your data using the \code{id_make} function.
}
\examples{
# You can either use a pscl rollcall object or a vote/score matrix 
# where persons/legislators are in the rows
# and items/bills are in the columns

library(dplyr)

# First, using a rollcall object with the 114th Senate's rollcall votes:

data('senate114')

to_idealstan <-   id_make(score_data = senate114,
ordinal = FALSE,
include_pres=FALSE)

}
