% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstan_generics.R
\docType{methods}
\name{id_post_pred,idealstan-method}
\alias{id_post_pred,idealstan-method}
\title{Posterior Prediction for \code{idealstan} objects}
\usage{
\S4method{id_post_pred}{idealstan}(object, draws = 100,
  sample_scores = NULL, ...)
}
\arguments{
\item{object}{A fitted \code{idealstan} object}

\item{draws}{The number of draws to use from the total number of posterior draws (default is 100).}

\item{sample_scores}{In addition to reducing the number of posterior draws used to calculate the posterior predictive distribution.}

\item{...}{Any other arguments passed on to posterior_predict (currently none available)}
}
\description{
This function will draw from the posterior predictive distribution of the outcome, i.e., all the scores or 
 votes that are used to create the \code{idealstan} model. 
 
 You can then use functions such as 
 \code{\link[bayesplot]{ppc_bars}} to see how well the model does returning the correct number of categories
 in the score/vote matrix. 
 Also see \code{help("posterior_predict", package = "rstanarm")}
}
