% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_package.R
\name{idem-parameters}
\alias{idem-parameters}
\title{List of parameters for \code{idem} analysis}
\arguments{
\item{trt}{Variable name for the Control (0) and Intervention (1) treatment
assignments in the dataset.}

\item{surv}{Variable name for the survival (time to event) variable in the
dataset.}

\item{outcome}{Chronologically ordered vector of variable names for clinical
outcomes in the dataset excluding baseline.}

\item{y0}{Variable name of the baseline clinical outcome.}

\item{cov}{Vector of variable names for the covariates used in the imputation
procedure for missing clinical outcomes.}

\item{endfml}{\code{R} expression indicating the user-specified final outcome of
interest. This is the function for \eqn{Z} of one or more of \eqn{Y_k}'s.}

\item{duration}{Length of the study. This is the time at which subjects' are
assumed to be censored.}

\item{bounds}{Numeric vector of lower and upper bounds for subjects' imputed
clinical outcomes.}

\item{trt.label}{label of the treatment arms}

\item{unitTime}{Unit of time measurement for survival and function outcome time points}
}
\description{
The parameters used by most of the functions in \code{idem} are organized as
a list. These parameters include variable names in the analysis dataset,
endpoint specification, duration of the study, etc..
}
\examples{

## for example abc dataset

lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                y0=NULL, endp=c("Y2"),
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2",
                duration=365, bounds=c(0,100));


}

