% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_analysis.R
\name{print.IDEMINFER}
\alias{print.IDEMINFER}
\title{Print inference results}
\usage{
\method{print}{IDEMINFER}(x, delta0 = NULL, delta1 = NULL, ...)
}
\arguments{
\item{x}{A class \code{IDEMINFER} list generated by \code{\link{imInfer}}}

\item{delta0}{Selected treatment arm 0 sensitivity parameters}

\item{delta1}{Selected treatment arm 1 sensitivity parameters}

\item{...}{Extra arguments}
}
\description{
Print method of class \code{IDEMINFER} for treatment effect estimation and
hypothesis testing results
}
\examples{

\dontrun{
rst.abc <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                 y0=NULL, endfml="Y2",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), duration=365, bounds=c(0,100));
rst.fit <- imFitModel(rst.abc);
rst.imp <- imImpAll(rst.fit, deltas=c(-0.25,0,0.25),
                    normal=TRUE, chains = 2, iter = 2000, warmup = 1000);
rst.test <- imInfer(rst.imp, n.boot = 100);
print(rst.test, delta0 = 0, delta1  = 0.15)}

}

