% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEIS.R
\name{SEIS_demographics_ode}
\alias{SEIS_demographics_ode}
\title{Susceptible-Exposed-Infected-Susceptible Model with Simple Demographics}
\usage{
SEIS_demographics_ode(t, x, params)
}
\arguments{
\item{t}{The timestep over which to calculate derivatives}

\item{x}{A numeric vector of compartment populations.}

\item{params}{A named vector of parameter values.}
}
\value{
A vector of derivatives
}
\description{
Susceptible-Exposed-Infected-Susceptible Model with Simple Demographics
}
\examples{
##Model Input
S_0 <- 989
E_0 <- 10
I_0 <- 1
beta <- 3
chi <- 0.5
gamma <- 1/2
mu <- 1/81
parameters <- c(beta = beta, gamma = gamma,
 chi = chi, mu = mu)
inits <- c(S = S_0, E = E_0, I = I_0)

SEIS_demographics_ode(1, inits, parameters)
}
